## 实测：阿里云百炼上线「全周期 MCP 服务」，AI 工具一站式托管

长话短说：

今天，**阿里云百炼正式上线了 MCP（Model Context Protocol）服务的完整平台能力**，覆盖从服务注册、云托管，到 Agent 调用、流程组合的全生命周期。

![](https://imagedelivery.net/qGOFcc1O8XwTZW3W1JAHHg/86e0115a-26c0-4338-e076-88fb8c23f700/public)

https://bailian.console.aliyun.com/

很不错！这事儿算是一个转变：**工具调用，不再是模型厂的「私有功能」**，而是被抽象为一种通用能力，并具备了完整的产品形态。

> 换句话说
>
> 百炼把 MCP Client 和 MCP Server 封在了一起，放在了 MAAS 上

于是，第一时间我上手试了试，本文也会顺着讲清楚三件事：

1.  1\. 这套 MCP 服务，能做什么？
2.  2\. 怎么用？
3.  3\. 和 Plugin 有什么区别？

---

## 01 ｜ MCP 能干啥

这里我测了两个典型的 Agent 例子，分别是「导航推荐助手」和「网页抓取助手」。

![](https://imagedelivery.net/qGOFcc1O8XwTZW3W1JAHHg/cb4f10bd-5370-445a-9262-9cb40a1a5300/public)

在百炼上，可以通过多种方式，构建 Agent

### 单 MCP 调用：高德地图 + AI 导游

这是一个简单的智能体应用，目标是：**根据用户的旅行目的地，生成当天的城市游推荐方案，并串联天气、位置、美食和导航任务。**

整个过程没有写代码，只是在百炼广场上开通高德地图（Amap Maps）的 MCP 服务，然后在「创建智能体应用」后，拉取这个 MCP 服务。

下面的视频是原速，可以感受下：

输入一个城市，比如“西安”，Agent 会自动：

1.  1\. 查询当天西安天气
2.  2\. 基于定位列出附近的景点、餐饮店
3.  3\. 安排出行路径（如骑行/地铁）
4.  4\. 给出推荐行程描述和地图跳转链接

整个任务链由 Agent 自动执行，所有服务来自百炼托管的 MCP 接口，无需我们部署服务器、写 API 代码或解析参数文档。

---

### 多 MCP 调用：网页抓取 + 数据生成

这是一个稍微复杂的 Case，通过构建工作流，让 AI 帮我取抓取网页，然后进行页面提取，最后保存在 Notion 里。

从流程上来说，就是

1.  1\. 大模型识别对话中的 URL
2.  2\. 通过 Firecrawl 抓取这个页面的信息
3.  3\. 通过大模型对信息进行总结
4.  4\. 将总结后的信息，上传到 Notion

这一套工具链同样通过 MCP 服务构建，串联了「Firecrawl」、大模型本身的处理，以及「Notion」等多个内容，全部可复用、可组合，也不依赖特定模型。

---

## 02 ｜百炼上的 MCP 怎么用？

在百炼 MCP 平台上，开发者可以通过两种方式使用 MCP 服务。

地址在这里：https://bailian.console.aliyun.com/?tab=app#/mcp-manage

### 第一种：直接用官方托管服务（选服务）

目前，百炼已经上线了 15 款 MCP 的云服务，并提供了 61 款社区 MCP 的介绍，更多的还在路上。

![](https://imagedelivery.net/qGOFcc1O8XwTZW3W1JAHHg/78367a90-f9d4-4f46-bd97-3f31a9466500/public)

以上服务已部署，更多服务在路上

![](https://imagedelivery.net/qGOFcc1O8XwTZW3W1JAHHg/772819d4-d08e-472b-46c1-17fb62a6bd00/public)

这些都是社区 MCP

这种方式适合绝大多数场景，几乎“零门槛”：

1.  1\. 打开 MCP 服务广场
2.  2\. 找到你需要的服务（如高德、GitHub、Notion）
3.  3\. 点开通，填写 API key（如有）
4.  4\. 就能在 Agent 或流程中直接调用

服务由百炼托管在函数计算上，调用即加载、通过 API 按量计费。

上面测试的高德导航、网页抓取等场景，都是走这一套流程。开发者不需要管部署，不需要写 Glue Code，调用非常稳定，尤其适合原型验证和组合式 Agent 设计。

> 据知情人士透露
>
> 百炼 MCP 服务将是阿里 AI 商业化重要落棋。
>
> 未来，阿里的服务，以及更多的三方应用，都将逐步上线到百炼，来满足任意场景 Agent 的开发需求。

---

### 第二种：自建服务（注册服务）

如果你有自己的 API，或者需要引入社区里的 MCP server（比如从 GitHub 上 clone 的开源项目），也可以走“自建部署”的路径：

1.  1\. 打开“注册服务”界面
2.  2\. 贴一下  `npx`  安装 或 Python 脚本（Python  暂还是灰的）
3.  3\. 系统会自动创建一个函数计算实例来托管你的服务
4.  4\. 注册成功后，该服务就能作为 MCP 工具被调用

![](https://imagedelivery.net/qGOFcc1O8XwTZW3W1JAHHg/3eeb83ca-877b-423e-15b1-57b813eb1e00/public)

bailian.console.aliyun.com/?tab=app#/mcp-manage/create

这条路径稍微偏“开发者向”，但整个过程比传统的服务器部署方式要简单得多：

- • 不需要自己买机器
- • 不需要配置负载均衡或权限系统
- • 可以通过文本配置定义 schema，自动生成模型调用示例

比较适合企业开发者将内部服务 MCP 化，或技术团队接入外部服务做统一封装。一句话总结就是：

> 以前做一个“插件”要写代码、跑服务、调结构，现在开个服务就是点几下配置。

---

## 03 ｜ MCP 和 Plugin 的区别

我相信，很多人还会有个反应：**这不就是 Plugin？**

对此，我也特意和百炼的朋友聊了这个问题，得到的回答很明确：

> Plugin 是为某个模型写的私有接口描述；MCP 是跨模型、跨平台可复用的通用协议。

差别主要体现在三个层面：

### 协议开放性

Plugin 是各厂商其自己模型设计的，无法直接复用到其他模型平台。而 MCP 的目标是**让所有模型理解同一种“服务语言”**。无论 Claude、GPT、百炼自有模型，理论上都能读懂相同的 MCP 接口描述，并做出合理调度。

![](https://imagedelivery.net/qGOFcc1O8XwTZW3W1JAHHg/8d143006-f87e-4c7a-fb2b-6d170f3a2300/public)

MCP 和 Plugin 的区别 be like

### 服务部署方式

Plugin 开发者需要自己部署服务，并管理调用、安全、负载等细节。MCP 在百炼的实现中，**服务由平台托管**，开发者只需提供逻辑，其他都交由平台自动完成（如函数计算、鉴权转发等）。

### 调用范式

Plugin 更像是“硬编码调用”：定义好 schema，模型识别后调用一次函数。MCP 支持的是**多步调度、多工具组合**，更适合 Agent 执行复杂任务时使用。

---

> 在我看来
>
> MCP 是对 Plugin/Function Calling/Tool Using 再封装了一轮，这样迁移环境的时候，节省了一部分调配的功夫。

---

## 写在最后：从工程对接，到能力平台

**在 MCP 之前，让 AI 调用外部工具，更像是一项繁琐的工程任务**，你需要写描述、调接口、配参数、部署服务等等...**现在，这些正在被重新定义为一种标准化的、平台化的能力**。

在我看来，这是一种焦点的转移：

- • **过去，重心在“人”**：工具主要服务于开发者，AI 需要被动适应。
- • **现在，重心在“AI”**：服务被设计成易于 AI 理解和使用，主动拥抱模型。

非常有趣。

> 来源：赛博禅心
